/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

public final class Orientation3D {
    public static final Orientation3D DEFAULT = new Orientation3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    private final double ix;
    private final double iy;
    private final double iz;
    private final double jx;
    private final double jy;
    private final double jz;
    private final double kx;
    private final double ky;
    private final double kz;

    Orientation3D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.ix = d;
        this.iy = d2;
        this.iz = d3;
        this.jx = d4;
        this.jy = d5;
        this.jz = d6;
        this.kx = d7;
        this.ky = d8;
        this.kz = d9;
    }

    Orientation3D(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, d2 * d6 - d3 * d5, d3 * d4 - d * d6, d * d5 - d2 * d4);
    }

    public static Orientation3D getSomeInstance(double d, double d2, double d3) {
        double d4;
        double d5 = d >= 0.0 ? d : -d;
        double d6 = d2 >= 0.0 ? d2 : -d2;
        double d7 = d4 = d3 >= 0.0 ? d3 : -d3;
        if (d6 < d4) {
            if (d5 < d6) {
                return Orientation3D.getInstance(d, d2, d3, 1.0, 0.0, 0.0);
            }
            return Orientation3D.getInstance(d, d2, d3, 0.0, 1.0, 0.0);
        }
        if (d5 < d4) {
            return Orientation3D.getInstance(d, d2, d3, 1.0, 0.0, 0.0);
        }
        return Orientation3D.getInstance(d, d2, d3, 0.0, 0.0, 1.0);
    }

    public static Orientation3D getInstance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 1.0 / Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = (d *= d7) * d4 + (d2 *= d7) * d5 + (d3 *= d7) * d6;
        d7 = 1.0 / Math.sqrt((d4 -= d * d8) * d4 + (d5 -= d2 * d8) * d5 + (d6 -= d3 * d8) * d6);
        return new Orientation3D(d, d2, d3, d4 *= d7, d5 *= d7, d6 *= d7);
    }

    public double getIx() {
        return this.ix;
    }

    public double getIy() {
        return this.iy;
    }

    public double getIz() {
        return this.iz;
    }

    public double getJx() {
        return this.jx;
    }

    public double getJy() {
        return this.jy;
    }

    public double getJz() {
        return this.jz;
    }

    public double getKx() {
        return this.kx;
    }

    public double getKy() {
        return this.ky;
    }

    public double getKz() {
        return this.kz;
    }

    public double transformX(double d, double d2, double d3) {
        return d * this.ix + d2 * this.jx + d3 * this.kx;
    }

    public double transformY(double d, double d2, double d3) {
        return d * this.iy + d2 * this.jy + d3 * this.ky;
    }

    public double transformZ(double d, double d2, double d3) {
        return d * this.iz + d2 * this.jz + d3 * this.kz;
    }

    public double inverseTransformX(double d, double d2, double d3) {
        return d * this.ix + d2 * this.iy + d3 * this.iz;
    }

    public double inverseTransformY(double d, double d2, double d3) {
        return d * this.jx + d2 * this.jy + d3 * this.jz;
    }

    public double inverseTransformZ(double d, double d2, double d3) {
        return d * this.kx + d2 * this.ky + d3 * this.kz;
    }

    public Orientation3D superposition(Orientation3D orientation3D) {
        return new Orientation3D(this.ix * orientation3D.ix + this.iy * orientation3D.jx + this.iz * orientation3D.kx, this.ix * orientation3D.iy + this.iy * orientation3D.jy + this.iz * orientation3D.ky, this.ix * orientation3D.iz + this.iy * orientation3D.jz + this.iz * orientation3D.kz, this.jx * orientation3D.ix + this.jy * orientation3D.jx + this.jz * orientation3D.kx, this.jx * orientation3D.iy + this.jy * orientation3D.jy + this.jz * orientation3D.ky, this.jx * orientation3D.iz + this.jy * orientation3D.jz + this.jz * orientation3D.kz).revive();
    }

    public Orientation3D rotateI(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * this.jx + d3 * this.kx;
        double d5 = d2 * this.jy + d3 * this.ky;
        double d6 = d2 * this.jz + d3 * this.kz;
        return new Orientation3D(this.ix, this.iy, this.iz, d4, d5, d6).revive();
    }

    public Orientation3D rotateJ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = -d3 * this.kx + d2 * this.ix;
        double d5 = -d3 * this.ky + d2 * this.iy;
        double d6 = -d3 * this.kz + d2 * this.iz;
        return new Orientation3D(d4, d5, d6, this.jx, this.jy, this.jz).revive();
    }

    public Orientation3D rotateK(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * this.ix + d3 * this.jx;
        double d5 = d2 * this.iy + d3 * this.jy;
        double d6 = d2 * this.iz + d3 * this.jz;
        double d7 = -d3 * this.ix + d2 * this.jx;
        double d8 = -d3 * this.iy + d2 * this.jy;
        double d9 = -d3 * this.iz + d2 * this.jz;
        return new Orientation3D(d4, d5, d6, d7, d8, d9).revive();
    }

    public Orientation3D rotate(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = this.ix;
        double d13 = this.iy;
        double d14 = this.iz;
        double d15 = this.jx;
        double d16 = this.jy;
        double d17 = this.jz;
        if (d != 0.0) {
            d11 = Math.cos(d);
            d10 = Math.sin(d);
            d9 = d11 * d13 - d10 * d14;
            d8 = d10 * d13 + d11 * d14;
            d7 = d11 * d16 - d10 * d17;
            d6 = d10 * d16 + d11 * d17;
            d13 = d9;
            d14 = d8;
            d16 = d7;
            d17 = d6;
        }
        if (d2 != 0.0) {
            d11 = Math.cos(d2);
            d10 = Math.sin(d2);
            d8 = d11 * d14 - d10 * d12;
            d5 = d10 * d14 + d11 * d12;
            d6 = d11 * d17 - d10 * d15;
            d4 = d10 * d17 + d11 * d15;
            d14 = d8;
            d12 = d5;
            d17 = d6;
            d15 = d4;
        }
        if (d3 != 0.0) {
            d11 = Math.cos(d3);
            d10 = Math.sin(d3);
            d5 = d11 * d12 - d10 * d13;
            d9 = d10 * d12 + d11 * d13;
            d4 = d11 * d15 - d10 * d16;
            d7 = d10 * d15 + d11 * d16;
            d12 = d5;
            d13 = d9;
            d15 = d4;
            d16 = d7;
        }
        return new Orientation3D(d12, d13, d14, d15, d16, d17).revive();
    }

    public Orientation3D rotate(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19 = Math.cos(d4);
        double d20 = Math.sin(d4);
        if ((d18 = Math.sqrt((d17 = this.ix - (d16 = (d15 = this.ix * (d *= (d14 = 1.0 / Math.sqrt(d * d + d2 * d2 + d3 * d3))) + this.iy * (d2 *= d14) + this.iz * (d3 *= d14)) * d)) * d17 + (d13 = this.iy - (d12 = d15 * d2)) * d13 + (d11 = this.iz - (d10 = d15 * d3)) * d11)) < 1.0E-9) {
            return this.rotateI(d4);
        }
        d14 = 1.0 / d18;
        double d21 = d2 * (d11 *= d14) - d3 * (d13 *= d14);
        double d22 = d3 * (d17 *= d14) - d * d11;
        double d23 = d * d13 - d2 * d17;
        double d24 = d19 * d17 + d20 * d21;
        double d25 = d19 * d13 + d20 * d22;
        double d26 = d19 * d11 + d20 * d23;
        d14 = Math.abs(d24 * d24 + d25 * d25 + d26 * d26 - 1.0);
        if (d9 > 0.01) {
            throw new AssertionError((Object)("|norm| = " + d14 + " != 1 in " + this.getClass().getName() + ".rotate method"));
        }
        double d27 = d16 + d18 * d24;
        double d28 = d12 + d18 * d25;
        double d29 = d10 + d18 * d26;
        double d30 = this.jx * d + this.jy * d2 + this.jz * d3;
        double d31 = d30 * d;
        d17 = this.jx - d31;
        double d32 = d30 * d2;
        d13 = this.jy - d32;
        double d33 = d30 * d3;
        d11 = this.jz - d33;
        d18 = Math.sqrt(d17 * d17 + d13 * d13 + d11 * d11);
        if (d18 < 1.0E-9) {
            return this.rotateJ(d4);
        }
        d14 = 1.0 / d18;
        d21 = d2 * (d11 *= d14) - d3 * (d13 *= d14);
        d22 = d3 * (d17 *= d14) - d * d11;
        d23 = d * d13 - d2 * d17;
        d24 = d19 * d17 + d20 * d21;
        d25 = d19 * d13 + d20 * d22;
        d26 = d19 * d11 + d20 * d23;
        d14 = Math.abs(d24 * d24 + d25 * d25 + d26 * d26 - 1.0);
        if (d8 > 0.01) {
            throw new AssertionError((Object)("|newa| = " + d14 + " != 1 in " + this.getClass().getName() + ".rotate method"));
        }
        double d34 = d31 + d18 * d24;
        double d35 = d32 + d18 * d25;
        double d36 = d33 + d18 * d26;
        d14 = Math.abs(d27 * d27 + d28 * d28 + d29 * d29 - 1.0);
        if (d7 > 0.01) {
            throw new AssertionError((Object)("|newI| = " + d14 + " != 1 in " + this.getClass().getName() + ".rotate method"));
        }
        d14 = Math.abs(d34 * d34 + d35 * d35 + d36 * d36 - 1.0);
        if (d6 > 0.01) {
            throw new AssertionError((Object)("|newJ| = " + d14 + " != 1 in " + this.getClass().getName() + ".rotate method"));
        }
        d14 = Math.abs(d27 * d34 + d28 * d35 + d29 * d36);
        if (d5 > 0.01) {
            throw new AssertionError((Object)("newI * newJ = " + d14 + " != 0 in " + this.getClass().getName() + ".rotate method"));
        }
        return new Orientation3D(d27, d28, d29, d34, d35, d36).revive();
    }

    public String toString() {
        return "I=(" + this.ix + "," + this.iy + "," + this.iz + "),J=(" + this.jx + "," + this.jy + "," + this.jz + "),K=(" + this.kx + "," + this.ky + "," + this.kz + ")";
    }

    public int hashCode() {
        int n = 0;
        n = 37 * n + Orientation3D.hashCode(this.ix);
        n = 37 * n + Orientation3D.hashCode(this.iy);
        n = 37 * n + Orientation3D.hashCode(this.iz);
        n = 37 * n + Orientation3D.hashCode(this.jx);
        n = 37 * n + Orientation3D.hashCode(this.jy);
        n = 37 * n + Orientation3D.hashCode(this.jz);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Orientation3D)) {
            return false;
        }
        Orientation3D orientation3D = (Orientation3D)object;
        return Double.doubleToLongBits(orientation3D.ix) == Double.doubleToLongBits(this.ix) && Double.doubleToLongBits(orientation3D.iy) == Double.doubleToLongBits(this.iy) && Double.doubleToLongBits(orientation3D.iz) == Double.doubleToLongBits(this.iz) && Double.doubleToLongBits(orientation3D.jx) == Double.doubleToLongBits(this.jx) && Double.doubleToLongBits(orientation3D.jy) == Double.doubleToLongBits(this.jy) && Double.doubleToLongBits(orientation3D.jz) == Double.doubleToLongBits(this.jz);
    }

    Orientation3D revive() {
        return Orientation3D.getInstance(this.ix, this.iy, this.iz, this.jx, this.jy, this.jz);
    }

    private static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }
}

