/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import net.algart.drawing3d.CoordinateSystem3D;
import net.algart.drawing3d.DrawingRule;
import net.algart.drawing3d.Pixel3DDrawer;
import net.algart.drawing3d.Shape3D;
import net.algart.drawing3d.SimpleDrawer3D;
import net.algart.drawing3d.Sphere3D;

public class Sphere3DDrawingRule
implements DrawingRule {
    public boolean isApplicable(Shape3D shape3D, Object object) {
        return shape3D instanceof Sphere3D;
    }

    public void draw(Shape3D shape3D, Pixel3DDrawer pixel3DDrawer, CoordinateSystem3D coordinateSystem3D, Rectangle2D rectangle2D, double d, Color color) {
        if (shape3D == null) {
            throw new NullPointerException("Null shape argument");
        }
        if (pixel3DDrawer == null) {
            throw new NullPointerException("Null pixelDrawer argument");
        }
        if (coordinateSystem3D == null) {
            throw new NullPointerException("Null coordinateSystemOfModel argument");
        }
        if (rectangle2D == null) {
            throw new NullPointerException("Null screenArea argument");
        }
        if (color == null) {
            throw new NullPointerException("Null color argument");
        }
        Sphere3D sphere3D = (Sphere3D)shape3D;
        double d2 = sphere3D.getRadius() * coordinateSystem3D.getScale();
        if (d2 <= 0.0) {
            return;
        }
        double d3 = sphere3D.getCenterX();
        double d4 = sphere3D.getCenterY();
        double d5 = sphere3D.getCenterZ();
        double d6 = coordinateSystem3D.transformX(d3, d4, d5);
        double d7 = coordinateSystem3D.transformY(d3, d4, d5);
        double d8 = coordinateSystem3D.transformZ(d3, d4, d5);
        if (d8 - d2 >= d) {
            return;
        }
        double d9 = rectangle2D.getMinX();
        double d10 = rectangle2D.getMaxX();
        double d11 = rectangle2D.getMinY();
        double d12 = rectangle2D.getMaxY();
        if (d6 + d2 < d9 || d6 - d2 > d10 || d7 + d2 < d11 || d7 - d2 > d12) {
            return;
        }
        boolean bl = pixel3DDrawer instanceof SimpleDrawer3D;
        int n = (int)Math.floor(d6 + 0.5);
        int n2 = (int)Math.floor(d7 + 0.5);
        int n3 = (int)Math.floor(d2 + 0.5);
        double d13 = d2 * d2;
        double d14 = 1.0 / d2;
        double d15 = d13 - (double)n3 * (double)n3;
        for (int i = -n3; i <= n3; ++i) {
            int n4 = n2 + i;
            double d16 = d15 - (double)i * (double)i;
            int n5 = -n3;
            int n6 = 2 * n5 + 1;
            while (n5 <= n3) {
                assert (d16 <= d13 + 0.1);
                if (d16 > 0.0) {
                    double d17 = Math.sqrt(d16);
                    double d18 = d8 + d17;
                    if (d18 <= d) {
                        pixel3DDrawer.drawPoint(n + n5, n4, d18, (double)n5 * d14, (double)i * d14, d17 * d14, color);
                    } else if (d8 - d17 < d) {
                        pixel3DDrawer.drawPoint(n + n5, n4, d, 0.0, 0.0, 1.0, color);
                    }
                    if (!bl && d8 - d17 <= d) {
                        pixel3DDrawer.drawPoint(n + n5, n4, d8 - d17, (double)n5 * d14, (double)i * d14, d17 * d14, color);
                    }
                }
                d16 -= (double)n6;
                ++n5;
                n6 += 2;
            }
        }
    }

    public void estimateContainingParallelepiped(double[] dArray, Shape3D shape3D, CoordinateSystem3D coordinateSystem3D) {
        if (dArray == null) {
            throw new NullPointerException("Null result argument");
        }
        if (shape3D == null) {
            throw new NullPointerException("Null shape argument");
        }
        if (coordinateSystem3D == null) {
            throw new NullPointerException("Null coordinateSystemOfModel argument");
        }
        Sphere3D sphere3D = (Sphere3D)shape3D;
        double d = sphere3D.getRadius() * coordinateSystem3D.getScale();
        if (d <= 0.0) {
            d = 0.0;
        }
        double d2 = sphere3D.getCenterX();
        double d3 = sphere3D.getCenterY();
        double d4 = sphere3D.getCenterZ();
        double d5 = coordinateSystem3D.transformX(d2, d3, d4);
        double d6 = coordinateSystem3D.transformY(d2, d3, d4);
        double d7 = coordinateSystem3D.transformZ(d2, d3, d4);
        dArray[0] = d5 - d;
        dArray[1] = d5 + d;
        dArray[2] = d6 - d;
        dArray[3] = d6 + d;
        dArray[4] = d7 - d;
        dArray[5] = d7 + d;
    }
}

