/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import java.util.Collection;
import net.algart.model3d.common.movement.model.AbstractMovementIntegrator;
import net.algart.model3d.common.movement.model.HavingMass;
import net.algart.model3d.common.movement.model.HavingVelocity;
import net.algart.model3d.common.movement.model.InteractionRule;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RungeKuttaMovementIntegrator
extends AbstractMovementIntegrator {
    private static final double[] RK4_ALPHA = new double[]{0.0, 0.5, 0.5, 1.0};
    private static final double[][] RK4_BETA = new double[][]{new double[0], {0.5}, {0.0, 0.5}, {0.0, 0.0, 1.0}};
    private static final double[] RK4_GAMMA = new double[]{0.16666666666666666, 0.3333333333333333, 0.3333333333333333, 0.16666666666666666};
    private static final double[] RKF45_ALPHA = new double[]{0.0, 0.25, 0.375, 0.9230769230769231, 1.0, 0.5};
    private static final double[][] RKF45_BETA = new double[][]{new double[0], {0.25}, {0.09375, 0.28125}, {0.8793809740555303, -3.277196176604461, 3.3208921256258535}, {2.0324074074074074, -8.0, 7.173489278752436, -0.20589668615984405}, {-0.2962962962962963, 2.0, -1.3816764132553607, 0.4529727095516569, -0.275}};
    private static final double[] RKF45_GAMMA = new double[]{0.11851851851851852, 0.0, 0.5189863547758284, 0.5061314903420167, -0.18, 0.03636363636363636};
    private static final double[] RKF45_ALTERNATE_GAMMA = new double[]{0.11574074074074074, 0.0, 0.5489278752436647, 0.5357229943916118, -0.2, 0.0};
    private final double[] alpha;
    private final double[][] beta;
    private final double[] gamma;
    private final double[] alternateGamma;
    private final double[][] dX;
    private final double[][] dY;
    private final double[][] dZ;
    private final double[][] dVX;
    private final double[][] dVY;
    private final double[][] dVZ;
    private double[] startX = new double[0];
    private double[] startY = new double[0];
    private double[] startZ = new double[0];
    private double[] startVX = new double[0];
    private double[] startVY = new double[0];
    private double[] startVZ = new double[0];
    private volatile double maxLastCoordinateError = Double.NaN;
    private volatile double maxLastVelocityError = Double.NaN;
    private volatile double meanLastCoordinateError = Double.NaN;
    private volatile double meanLastVelocityError = Double.NaN;

    private RungeKuttaMovementIntegrator(ItemSet itemSet, Collection<InteractionRule> collection, double d, double[] dArray, double[][] dArray2, double[] dArray3, double[] dArray4) {
        super(itemSet, collection, d);
        if (dArray == null) {
            throw new NullPointerException("Null alpha argument");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Null beta argument");
        }
        if (dArray3 == null) {
            throw new NullPointerException("Null gamma argument");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Empty alpha array");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("alpha and beta lengths mismatch: " + dArray.length + " != " + dArray2.length);
        }
        if (dArray.length != dArray3.length) {
            throw new IllegalArgumentException("alpha and gamma lengths mismatch: " + dArray.length + " != " + dArray3.length);
        }
        if (dArray4 != null && dArray.length != dArray4.length) {
            throw new IllegalArgumentException("alpha and alternateGamma lengths mismatch: " + dArray.length + " != " + dArray4.length);
        }
        this.alpha = (double[])dArray.clone();
        this.beta = (double[][])dArray2.clone();
        this.gamma = (double[])dArray3.clone();
        this.alternateGamma = dArray4 == null ? null : (double[])dArray4.clone();
        for (int i = 0; i < this.beta.length; ++i) {
            if (this.beta[i].length < i) {
                throw new IllegalArgumentException("Too short beta[" + i + "]: only " + this.beta[i].length + " elements");
            }
            double[] dArray5 = new double[i];
            System.arraycopy(this.beta[i], 0, dArray5, 0, i);
            this.beta[i] = dArray5;
        }
        this.dX = new double[dArray3.length][0];
        this.dY = new double[dArray3.length][0];
        this.dZ = new double[dArray3.length][0];
        this.dVX = new double[dArray3.length][0];
        this.dVY = new double[dArray3.length][0];
        this.dVZ = new double[dArray3.length][0];
    }

    public static RungeKuttaMovementIntegrator getGeneralizedRungeKuttaIntegrator(ItemSet itemSet, Collection<InteractionRule> collection, double d, double[] dArray, double[][] dArray2, double[] dArray3) {
        return new RungeKuttaMovementIntegrator(itemSet, collection, d, dArray, dArray2, dArray3, null);
    }

    public static RungeKuttaMovementIntegrator getGeneralizedRungeKuttaIntegrator(ItemSet itemSet, Collection<InteractionRule> collection, double d, double[] dArray, double[][] dArray2, double[] dArray3, double[] dArray4) {
        if (dArray4 == null) {
            throw new NullPointerException("Null alternateGamma argument");
        }
        return new RungeKuttaMovementIntegrator(itemSet, collection, d, dArray, dArray2, dArray3, null);
    }

    public static RungeKuttaMovementIntegrator getRungeKutta4Integrator(ItemSet itemSet, Collection<InteractionRule> collection, double d) {
        return new RungeKuttaMovementIntegrator(itemSet, (Collection)collection, d, RK4_ALPHA, RK4_BETA, RK4_GAMMA, null){

            public String toString() {
                return super.toString() + " (RK-4)";
            }
        };
    }

    public static RungeKuttaMovementIntegrator getRungeKuttaFehlberg45Integrator(ItemSet itemSet, Collection<InteractionRule> collection, double d) {
        return new RungeKuttaMovementIntegrator(itemSet, (Collection)collection, d, RKF45_ALPHA, RKF45_BETA, RKF45_GAMMA, RKF45_ALTERNATE_GAMMA){

            public String toString() {
                return super.toString() + " (RKF-45)";
            }
        };
    }

    public double[] getAlpha() {
        return (double[])this.alpha.clone();
    }

    public double[][] getBeta() {
        double[][] dArray = (double[][])this.beta.clone();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double[])dArray[i].clone();
        }
        return dArray;
    }

    public double[] getGamma() {
        return (double[])this.gamma.clone();
    }

    public double[] getAlternateGamma() {
        return this.alternateGamma == null ? null : (double[])this.alternateGamma.clone();
    }

    @Override
    public void performIteration() {
        double d;
        double d2;
        Item item;
        int n;
        this.preprocess();
        double d3 = this.getDeltaT();
        double d4 = this.getT();
        for (n = 0; n < this.n; ++n) {
            Item item2 = this.itemSet.get(n);
            if (!(item2 instanceof HavingVelocity) || !(item2 instanceof HavingMass)) continue;
            item = (HavingVelocity)item2;
            this.startX[n] = item.getCenterX();
            this.startY[n] = item.getCenterY();
            this.startZ[n] = item.getCenterZ();
            this.startVX[n] = item.getVelocityX();
            this.startVY[n] = item.getVelocityY();
            this.startVZ[n] = item.getVelocityZ();
        }
        for (n = 0; n < this.alpha.length; ++n) {
            this.setT(d4 + this.alpha[n] * d3);
            if (n > 0) {
                for (int i = 0; i < this.n; ++i) {
                    item = this.itemSet.get(i);
                    if (!(item instanceof HavingVelocity) || !(item instanceof HavingMass)) continue;
                    double d5 = this.startX[i];
                    double d6 = this.startY[i];
                    double d7 = this.startZ[i];
                    double d8 = this.startVX[i];
                    d2 = this.startVY[i];
                    d = this.startVZ[i];
                    for (int j = 0; j < n; ++j) {
                        d5 += this.beta[n][j] * this.dX[j][i];
                        d6 += this.beta[n][j] * this.dY[j][i];
                        d7 += this.beta[n][j] * this.dZ[j][i];
                        d8 += this.beta[n][j] * this.dVX[j][i];
                        d2 += this.beta[n][j] * this.dVY[j][i];
                        d += this.beta[n][j] * this.dVZ[j][i];
                    }
                    HavingVelocity havingVelocity = (HavingVelocity)item;
                    havingVelocity.setCenter(d5, d6, d7);
                    havingVelocity.setVelocity(d8, d2, d);
                }
                this.preprocess();
            }
            this.calculateLeftSide(this.dX[n], this.dY[n], this.dZ[n], this.dVX[n], this.dVY[n], this.dVZ[n], d3);
        }
        this.setT(d4 + d3);
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.n; ++i) {
            Item item3 = this.itemSet.get(i);
            if (!(item3 instanceof HavingVelocity) || !(item3 instanceof HavingMass)) continue;
            d2 = this.startX[i];
            d = this.startY[i];
            double d13 = this.startZ[i];
            double d14 = this.startVX[i];
            double d15 = this.startVY[i];
            double d16 = this.startVZ[i];
            for (int j = 0; j < this.gamma.length; ++j) {
                d2 += this.gamma[j] * this.dX[j][i];
                d += this.gamma[j] * this.dY[j][i];
                d13 += this.gamma[j] * this.dZ[j][i];
                d14 += this.gamma[j] * this.dVX[j][i];
                d15 += this.gamma[j] * this.dVY[j][i];
                d16 += this.gamma[j] * this.dVZ[j][i];
            }
            HavingVelocity havingVelocity = (HavingVelocity)item3;
            havingVelocity.setCenter(d2, d, d13);
            havingVelocity.setVelocity(d14, d15, d16);
            if (this.alternateGamma == null) continue;
            double d17 = this.startX[i];
            double d18 = this.startY[i];
            double d19 = this.startZ[i];
            double d20 = this.startVX[i];
            double d21 = this.startVY[i];
            double d22 = this.startVZ[i];
            for (int j = 0; j < this.gamma.length; ++j) {
                double d23 = Math.sqrt(((d17 += this.alternateGamma[j] * this.dX[j][i]) - d2) * (d17 - d2) + ((d18 += this.alternateGamma[j] * this.dY[j][i]) - d) * (d18 - d) + ((d19 += this.alternateGamma[j] * this.dZ[j][i]) - d13) * (d19 - d13));
                double d24 = Math.sqrt(((d20 += this.alternateGamma[j] * this.dVX[j][i]) - d14) * (d20 - d14) + ((d21 += this.alternateGamma[j] * this.dVY[j][i]) - d15) * (d21 - d15) + ((d22 += this.alternateGamma[j] * this.dVZ[j][i]) - d16) * (d22 - d16));
                d9 += d23;
                d10 += d24;
                d11 = Math.max(d11, d23);
                d12 = Math.max(d12, d24);
                ++n2;
            }
        }
        if (this.alternateGamma != null) {
            this.meanLastCoordinateError = d9 / (double)n2;
            this.meanLastVelocityError = d10 / (double)n2;
            this.maxLastCoordinateError = d11;
            this.maxLastVelocityError = d12;
        }
    }

    @Override
    public boolean isErrorInformationAvailable() {
        return this.alternateGamma != null;
    }

    @Override
    public double maxLastCoordinateError() {
        return this.maxLastCoordinateError;
    }

    @Override
    public double maxLastVelocityError() {
        return this.maxLastVelocityError;
    }

    @Override
    public double meanLastCoordinateError() {
        return this.meanLastCoordinateError;
    }

    @Override
    public double meanLastVelocityError() {
        return this.meanLastVelocityError;
    }

    @Override
    protected void preprocess() {
        int n = this.n;
        super.preprocess();
        if (this.n != n) {
            for (int i = 0; i < this.gamma.length; ++i) {
                this.dX[i] = new double[this.n];
                this.dY[i] = new double[this.n];
                this.dZ[i] = new double[this.n];
                this.dVX[i] = new double[this.n];
                this.dVY[i] = new double[this.n];
                this.dVZ[i] = new double[this.n];
            }
            this.startX = new double[this.n];
            this.startY = new double[this.n];
            this.startZ = new double[this.n];
            this.startVX = new double[this.n];
            this.startVY = new double[this.n];
            this.startVZ = new double[this.n];
        }
    }

    public String toString() {
        return "Runge-Kutta method";
    }
}

